package elaprendiz.graficos.filtradoresImagen;

import java.awt.image.RGBImageFilter;
import java.awt.Color;

/**
 * FiltroAlfa is a simple ImageFilter which makes one color of an image 
 * (determined at the filters construction) transparent. Its main use is 
 * for making transparent GIFs or images which have a single color 
 * background. This background is simply made transparent (alpha value 
 * equals zero) thus createing the desired effect.
 *
 * @version 1.0 March 26, 1997
 * @author  John Kloss
 */

public class FiltroAlfa extends RGBImageFilter {

  ////////////////////////////////////////
  // The color to be made transparent by
  // the FiltroAlfa.

  Color colorAlfa;

  /**
   * Constructor. This method creates an instance of FiltroAlfa. The
   * parameter colorAlfa indicates the color to be made transparent by
   * the filter. The constructor sets the RGBImageFilter value, 
   * canFilterIndexColorModel to true so that just the color table for
   * the image is filtered, not each pixel.
   *
   * @param colorAlfa      The color to be made transparent by the
   *                        FiltroAlfa.
   */
  public FiltroAlfa (Color alphaColor) {
    this.colorAlfa = alphaColor;
    canFilterIndexColorModel = true;
  }

  /**
   * Filter the image color table. If the value rgb matches the colorAlfa
   * set during construction, a transparent color value is returned (zero).
   * Otherwise, the original color value is returned unchanged.
   *
   * @param rgb             A color value in the image's color table.
   * @return                A transparent color value or the original value.
   */
  public int filterRGB (int x, int y, int rgb) {

    ////////////////////////////////////////
    // Parse out the rgb color values

    int rojo   = (rgb >> 16) & 0xff;
    int verde = (rgb >>  8) & 0xff;
    int azul  = (rgb      ) & 0xff;

    ////////////////////////////////////////
    // Compare the color created by these
    // values with colorAlfa.
    //
    // Note: The alpha value for rgb is
    //       ignored.

    if (colorAlfa.equals( new Color(rojo, verde, azul)))
      return 0;
    else
      return rgb;
  }
}
